"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var DefaultShapeIndicator_exports = {};
__export(DefaultShapeIndicator_exports, {
  DefaultShapeIndicator: () => DefaultShapeIndicator
});
module.exports = __toCommonJS(DefaultShapeIndicator_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_state_react = require("@tldraw/state-react");
var import_classnames = __toESM(require("classnames"));
var import_react = require("react");
var import_useEditor = require("../../hooks/useEditor");
var import_useEditorComponents = require("../../hooks/useEditorComponents");
var import_ErrorBoundary = require("../ErrorBoundary");
const EvenInnererIndicator = ({ shape, util }) => {
  return (0, import_state_react.useStateTracking)(
    "Indicator: " + shape.type,
    () => (
      // always fetch the latest shape from the store even if the props/meta have not changed, to avoid
      // calling the render method with stale data.
      util.indicator(util.editor.store.unsafeGetWithoutCapture(shape.id))
    )
  );
};
const InnerIndicator = ({ editor, id }) => {
  const shape = (0, import_state_react.useValue)("shape for indicator", () => editor.store.get(id), [editor, id]);
  const { ShapeIndicatorErrorFallback } = (0, import_useEditorComponents.useEditorComponents)();
  if (!shape || shape.isLocked) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_ErrorBoundary.OptionalErrorBoundary,
    {
      fallback: ShapeIndicatorErrorFallback,
      onError: (error) => editor.annotateError(error, { origin: "react.shapeIndicator", willCrashApp: false }),
      children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(EvenInnererIndicator, { shape, util: editor.getShapeUtil(shape) }, shape.id)
    }
  );
};
const DefaultShapeIndicator = (0, import_react.memo)(function DefaultShapeIndicator2({
  shapeId,
  className,
  color,
  hidden,
  opacity
}) {
  const editor = (0, import_useEditor.useEditor)();
  const rIndicator = (0, import_react.useRef)(null);
  (0, import_state_react.useQuickReactor)(
    "indicator transform",
    () => {
      const elm = rIndicator.current;
      if (!elm) return;
      const pageTransform = editor.getShapePageTransform(shapeId);
      if (!pageTransform) return;
      elm.style.setProperty("transform", pageTransform.toCssString());
    },
    [editor, shapeId]
  );
  (0, import_react.useLayoutEffect)(() => {
    const elm = rIndicator.current;
    if (!elm) return;
    elm.style.setProperty("display", hidden ? "none" : "block");
  }, [hidden]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("svg", { ref: rIndicator, className: (0, import_classnames.default)("tl-overlays__item", className), children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)("g", { className: "tl-shape-indicator", stroke: color ?? "var(--color-selected)", opacity, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(InnerIndicator, { editor, id: shapeId }) }) });
});
//# sourceMappingURL=DefaultShapeIndicator.js.map
